#include "PlatformMutex.h"
#include <assert.h>

namespace UnityPlugin
{
	PlatformMutex::PlatformMutex()
	{
		sys_lwmutex_attribute_initialize(lwmutexattr);
		lwmutexattr.attr_recursive = SYS_SYNC_RECURSIVE;
 		sys_lwmutex_create(&lwmutex, &lwmutexattr);
	}

	PlatformMutex::~PlatformMutex ()
	{
		sys_lwmutex_destroy(&lwmutex);
	}

	void PlatformMutex::Lock()
	{
		sys_lwmutex_lock( &lwmutex, 0 );
	}

	void PlatformMutex::Unlock()
	{
		sys_lwmutex_unlock( &lwmutex );
	}

	bool PlatformMutex::TryLock()
	{
		return (CELL_OK == sys_lwmutex_trylock( &lwmutex ));
	}

	PlatformSemaphore::PlatformSemaphore()
	{
		Create();
	}

	PlatformSemaphore::~PlatformSemaphore()
	{
		Destroy();
	}

	void PlatformSemaphore::Reset()
	{
		Destroy();
		Create();
	}

	void PlatformSemaphore::Create()
	{
		if (sem_init(&m_Semaphore, 0, 0) == -1) 
		{
			assert(!"Open");
		}
	}

	void PlatformSemaphore::Destroy()
	{
		if (sem_destroy(&m_Semaphore) == -1) 
		{
			assert(!"Destroy");
		}
	}

	void PlatformSemaphore::WaitForSignal()
	{
		if (sem_wait(&m_Semaphore) == -1) 
		{
			assert(!"Wait");
		}
	}

	void PlatformSemaphore::Signal()
	{
		if (sem_post(&m_Semaphore) == -1) 
		{
				assert(!"Signal");
		}
	}
}